import { type NextRequest, NextResponse } from "next/server"
import { neon } from "@neondatabase/serverless"

const sql = neon(process.env.DATABASE_URL!)

export async function DELETE(request: NextRequest, { params }: { params: { id: string } }) {
  try {
    const songId = Number.parseInt(params.id)

    const result = await sql`
      DELETE FROM songs 
      WHERE id = ${songId}
      RETURNING id
    `

    if (result.length === 0) {
      return NextResponse.json(
        {
          success: false,
          message: "Música não encontrada",
        },
        { status: 404 },
      )
    }

    return NextResponse.json({
      success: true,
      message: "Música deletada com sucesso",
    })
  } catch (error) {
    console.error("Delete song error:", error)
    return NextResponse.json(
      {
        success: false,
        message: "Erro interno do servidor",
      },
      { status: 500 },
    )
  }
}

export async function PATCH(request: NextRequest, { params }: { params: { id: string } }) {
  try {
    const { repertoireGroupId } = await request.json()
    const songId = Number.parseInt(params.id)

    const result = await sql`
      UPDATE songs 
      SET repertoire_group_id = ${repertoireGroupId}, updated_at = NOW()
      WHERE id = ${songId}
      RETURNING id, title, artist, youtube_url, repertoire_group_id
    `

    if (result.length === 0) {
      return NextResponse.json(
        {
          success: false,
          message: "Música não encontrada",
        },
        { status: 404 },
      )
    }

    return NextResponse.json({
      success: true,
      song: result[0],
    })
  } catch (error) {
    console.error("Move song error:", error)
    return NextResponse.json(
      {
        success: false,
        message: "Erro interno do servidor",
      },
      { status: 500 },
    )
  }
}

export async function PUT(request: NextRequest, { params }: { params: { id: string } }) {
  try {
    const { title, artist, youtube_url } = await request.json()
    const songId = Number.parseInt(params.id)

    const result = await sql`
      UPDATE songs 
      SET title = ${title}, artist = ${artist}, youtube_url = ${youtube_url}, updated_at = NOW()
      WHERE id = ${songId}
      RETURNING id, title, artist, youtube_url, repertoire_group_id
    `

    if (result.length === 0) {
      return NextResponse.json(
        {
          success: false,
          message: "Música não encontrada",
        },
        { status: 404 },
      )
    }

    return NextResponse.json({
      success: true,
      ...result[0],
    })
  } catch (error) {
    console.error("Update song error:", error)
    return NextResponse.json(
      {
        success: false,
        message: "Erro interno do servidor",
      },
      { status: 500 },
    )
  }
}
